uniform sampler2D texLeft;
uniform sampler2D texRight;
uniform sampler2D texNoise;

uniform float crossfader;
uniform float randomSeed;
uniform float levelLeft;
uniform float levelRight;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  vec4 color = gl_Color;

	vec2 offset = (texture2D(texNoise, vec2(uv.x / 10.0, fract(uv.y /10.0 + min(0.9, randomSeed)))).xy * 2.0 - 1.0);
	vec2 center = uv + offset/10.0;
	vec2 toUV = uv - center;
	float len = length(toUV);
	vec2 normToUV = toUV / len;
	float angle = atan(normToUV.x,normToUV.y);
  angle += 3.141592*2.0*crossfader;
	vec2 newOffset;
  newOffset.y=sin(angle);
  newOffset.x=cos(angle);
	newOffset *= len;
    
	vec4 color1 = texture2D(texLeft, fract(center + newOffset));
  color1.a=levelLeft;
	vec4 color2 = texture2D(texRight, fract(center + newOffset));
  color2.a=levelRight;	
  
  gl_FragColor = mix(color1, color2, crossfader);
}